-- FA+ count pane
local player = ...
local pss = STATSMAN:GetCurStageStats():GetPlayerStageStats(player)
local pn = tonumber(player:sub(-1))
local notes = pss:GetRadarPossible():GetValue("RadarCategory_TapsAndHolds")
local perfects = pss:GetTapNoteScores("TapNoteScore_W1")

local percent1 = (notes ~= 0) and string.format("%0.2f", math.floor(10000*(WF.FAPlusCount[pn][1]/notes))/100) or "0.00"
local percent2 = (notes ~= 0) and string.format("%0.2f", math.floor(10000*(WF.FAPlusCount[pn][2]/notes))/100) or "0.00"
local percent3 = (notes ~= 0) and string.format("%0.2f", math.floor(10000*(perfects/notes))/100) or "0.00"

local af = Def.ActorFrame{
    Name = "FAPlus",

    -- FA+ heading
    Def.ActorFrame{
        InitCommand=function(self)
            self:x( -115 )
            self:y( _screen.cy-40 )
        end,
    
        Def.Quad{
            InitCommand=function(self)
                self:diffuse( color("#101519") )
                    :y(-2)
                    :zoomto(70, 28)
            end
        },
    
        LoadFont("_wendy white")..{
            Text="FA+",
            InitCommand=function(self) self:horizalign("center"):zoom(0.25):xy( 0, -2) end,
        }
    },

    -- table
    Def.ActorFrame{
        InitCommand = function(self)
            self:xy(-104, _screen.cy - 12)
        end,
        -- header texts
        LoadFont("Common Normal")..{
            Text = "Window",
            InitCommand = function(self) self:zoom(0.833):x(32) end
        },
        LoadFont("Common Normal")..{
            Text = "Count",
            InitCommand = function(self) self:zoom(0.833):x(112) end
        },
        LoadFont("Common Normal")..{
            Text = "Percent",
            InitCommand = function(self) self:zoom(0.833):x(200) end
        },
        -- line under header
        Def.Quad{
            InitCommand = function(self) self:xy(-24, 12):horizalign("left"):zoomto(254,2) end
        },
        -- window names
        LoadFont("Common Normal")..{
            Text = "10ms",
            InitCommand = function(self) self:xy(52, 30):horizalign("right"):zoom(0.833) end
        },
        LoadFont("Common Normal")..{
            Text = "ECFA 12.5ms",
            InitCommand = function(self) self:xy(52, 58):horizalign("right"):zoom(0.833):diffuse(SL.JudgmentColors.ITG[1]) end
        },
        LoadFont("Common Normal")..{
            Text = "Perfect! 15ms",
            InitCommand = function(self) self:xy(52, 86):horizalign("right"):zoom(0.833):diffuse(SL.JudgmentColors.Waterfall[1]) end
        },
        -- count numbers
        LoadFont("_ScreenEvaluation numbers")..{
            Text = tostring(WF.FAPlusCount[pn][1]),
            InitCommand = function(self)
                self:xy(132, 28):horizalign("right"):zoom(0.4):maxwidth(64/0.4)
            end
        },
        LoadFont("_ScreenEvaluation numbers")..{
            Text = tostring(WF.FAPlusCount[pn][2]),
            InitCommand = function(self)
                self:xy(132, 56):horizalign("right"):zoom(0.4):maxwidth(64/0.4):diffuse(SL.JudgmentColors.ITG[1])
            end
        },
        LoadFont("_ScreenEvaluation numbers")..{
            Text = tostring(perfects),
            InitCommand = function(self)
                self:xy(132, 84):horizalign("right"):zoom(0.4):maxwidth(64/0.4):diffuse(SL.JudgmentColors.Waterfall[1])
            end
        },
        -- percents
        LoadFont("_ScreenEvaluation numbers")..{
            Text = percent1,
            InitCommand = function(self)
                self:xy(226, 28):horizalign("right"):zoom(0.4)
            end
        },
        LoadFont("_ScreenEvaluation numbers")..{
            Text = percent2,
            InitCommand = function(self)
                self:xy(226, 56):horizalign("right"):zoom(0.4):diffuse(SL.JudgmentColors.ITG[1])
            end
        },
        LoadFont("_ScreenEvaluation numbers")..{
            Text = percent3,
            InitCommand = function(self)
                self:xy(226, 84):horizalign("right"):zoom(0.4):diffuse(SL.JudgmentColors.Waterfall[1])
            end
        },
    }
}

return af